/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class Principal
extends JFrame {
    private JTextField campoPeso;
    private JTextField campoAltura;
    private JLabel resultado;

    public Principal() {
        this.setTitle("Calculadora de IMC");
        this.setSize(300, 200);
        this.setDefaultCloseOperation(3);
        this.setLayout(new GridLayout(4, 2));
        JLabel labelPeso = new JLabel("Peso (kg):");
        this.campoPeso = new JTextField();
        JLabel labelAltura = new JLabel("Altura (m):");
        this.campoAltura = new JTextField();
        JButton botaoCalcular = new JButton("Calcular IMC");
        this.resultado = new JLabel("Resultado aparecer\u00e1 aqui");
        this.add(labelPeso);
        this.add(this.campoPeso);
        this.add(labelAltura);
        this.add(this.campoAltura);
        this.add(botaoCalcular);
        this.add(this.resultado);
        botaoCalcular.addActionListener(new ActionListener(this){
            final /* synthetic */ Principal this$0;
            {
                Principal principal = this$0;
                Objects.requireNonNull(principal);
                this.this$0 = principal;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.calcularIMC();
            }
        });
    }

    private void calcularIMC() {
        try {
            double peso = Double.parseDouble(this.campoPeso.getText());
            double altura = Double.parseDouble(this.campoAltura.getText());
            double imc = peso / (altura * altura);
            String classificacao = imc < 18.5 ? "Abaixo do peso" : (imc < 24.9 ? "Peso normal" : (imc < 29.9 ? "Sobrepeso" : (imc < 39.9 ? "Obesidade" : "Obesidade Severa")));
            this.resultado.setText(String.format("IMC: %.2f - %s", imc, classificacao));
        }
        catch (NumberFormatException ex) {
            this.resultado.setText("Digite valores v\u00e1lidos!");
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new Principal().setVisible(true));
    }
}

