/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class Principal
extends JFrame {
    private static final Logger logger = Logger.getLogger(Principal.class.getName());
    private JLabel jLabelTitulo;
    private JScrollPane jScrollPane;
    private JTextArea jTextArea;
    private JTextField jTextField;
    private JButton jButtonEnviar;
    private JButton jButtonGuia;

    public Principal() {
        this.setTitle("PingMaster");
        this.initComponents();
    }

    private void initComponents() {
        this.jLabelTitulo = new JLabel("PingMaster");
        this.jScrollPane = new JScrollPane();
        this.jTextArea = new JTextArea();
        this.jTextField = new JTextField();
        this.jButtonEnviar = new JButton("Enviar");
        this.jButtonGuia = new JButton("Guia de Seguran\u00e7a");
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        this.jLabelTitulo.setFont(new Font("Segoe UI", 1, 18));
        this.jLabelTitulo.setHorizontalAlignment(0);
        this.jLabelTitulo.setVerticalAlignment(1);
        this.jLabelTitulo.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jTextArea.setEditable(false);
        this.jTextArea.setColumns(20);
        this.jTextArea.setRows(12);
        this.jScrollPane.setViewportView(this.jTextArea);
        this.jButtonEnviar.setFont(new Font("Segoe UI", 1, 12));
        this.jButtonEnviar.addActionListener(evt -> this.jButtonEnviarActionPerformed(evt));
        this.jButtonGuia.setFont(new Font("Segoe UI", 1, 12));
        this.jButtonGuia.addActionListener(this::mostrarGuiaSeguranca);
        this.getRootPane().setDefaultButton(this.jButtonEnviar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelTitulo, -1, 600, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jScrollPane, -2, 580, -2).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(12).addComponent(this.jTextField, -2, 320, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonEnviar, -2, 110, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonGuia, -2, 150, -2).addGap(0, 6, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(24).addComponent(this.jLabelTitulo).addGap(14).addComponent(this.jScrollPane, -2, 280, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField, -2, 28, -2).addComponent(this.jButtonEnviar, -2, 28, -2).addComponent(this.jButtonGuia, -2, 28, -2)).addContainerGap(12, Short.MAX_VALUE)));
        this.pack();
        this.setLocationRelativeTo(null);
        this.mostrarAvisoInicial();
    }

    private void mostrarAvisoInicial() {
        this.jTextArea.append("Aviso de seguran\u00e7a:\n");
        this.jTextArea.append("- Acessar redes como Tor, I2P e Freenet pode ser arriscado.\n");
        this.jTextArea.append("- Essas redes ajudam a evitar censura, mas exigem cuidado.\n");
        this.jTextArea.append("- Este programa s\u00f3 realiza ping na Surface Web.\n\n");
    }

    private void mostrarGuiaSeguranca(ActionEvent evt) {
        JDialog dialog = new JDialog(this, "Guia de Seguran\u00e7a", true);
        JTextArea guiaArea = new JTextArea();
        guiaArea.setEditable(false);
        guiaArea.setText("Guia de Seguran\u00e7a:\n\n1. Sempre use VPN antes de acessar redes alternativas.\n2. Prefira sistemas focados em anonimato (ex: Tails, IprediaOS).\n3. Nunca abra links desconhecidos ou suspeitos.\n4. Lembre-se: Tor (.onion), I2P (.i2p) e Freenet exigem clientes pr\u00f3prios.\n5. Este programa n\u00e3o testa ping em deep web, apenas informa.\n");
        JScrollPane scroll = new JScrollPane(guiaArea);
        dialog.add(scroll);
        dialog.setSize(420, 260);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private boolean isDeepWebHost(String host) {
        return host.endsWith(".onion") || host.endsWith(".i2p") || host.toLowerCase().contains("freenet");
    }

    private String identificarRede(String host) {
        if (host.endsWith(".onion")) {
            return "Rede: Tor (Deep Web)\nNavegadores: Tor Browser, Brave (com Tor)\nISO recomendada: Tails\nSeguran\u00e7a: Use VPN + Proxy\nObserva\u00e7\u00e3o: .onion n\u00e3o se resolve via DNS p\u00fablico.\n";
        }
        if (host.endsWith(".i2p")) {
            return "Rede: I2P\nNavegadores: I2P Browser\nISO recomendada: IprediaOS ou Tails com I2P\nSeguran\u00e7a: Use VPN + Proxy\nObserva\u00e7\u00e3o: .i2p n\u00e3o se resolve via DNS p\u00fablico.\n";
        }
        if (host.toLowerCase().contains("freenet")) {
            return "Rede: Freenet\nNavegadores: Qualquer navegador via cliente Freenet\nISO recomendada: Tails\nSeguran\u00e7a: Use VPN + Proxy\nObserva\u00e7\u00e3o: Freenet n\u00e3o usa DNS p\u00fablico convencional.\n";
        }
        return "Rede: Surface Web\nNavegadores: Chrome, Firefox, Edge, Brave\nISO recomendada: Ubuntu, Fedora, macOS\nSeguran\u00e7a: VPN recomendada\n";
    }

    private void jButtonEnviarActionPerformed(ActionEvent evt) {
        String host = this.jTextField.getText().trim();
        if (host.isEmpty()) {
            this.jTextArea.append("Por favor, informe um host ou dom\u00ednio.\n\n");
            return;
        }
        this.jTextArea.append("Verificando: " + host + "\n");
        this.jTextArea.append("----------------------------------------\n");
        String info = this.identificarRede(host);
        this.jTextArea.append(info);
        this.jTextArea.append("----------------------------------------\n");
        this.jTextArea.append(this.getProxyInfo());
        this.jTextArea.append(this.getVpnInfo());
        this.jTextArea.append("----------------------------------------\n");
        boolean deep = this.isDeepWebHost(host);
        if (deep) {
            this.jTextArea.append("Endere\u00e7os IP do host:\n");
            this.jTextArea.append("- IPv4: N/D (host de deep web n\u00e3o resolve via DNS p\u00fablico)\n");
            this.jTextArea.append("- IPv6: N/D (host de deep web n\u00e3o resolve via DNS p\u00fablico)\n\n");
            this.jTextArea.append("Ping n\u00e3o dispon\u00edvel fora da rede espec\u00edfica (Tor/I2P/Freenet).\n\n");
            return;
        }
        this.jTextArea.append(this.resolveHostAddresses(host));
        try {
            InetAddress inet = InetAddress.getByName(host);
            this.jTextArea.append("Pingando " + host + "...\n");
            if (inet.isReachable(3000)) {
                this.jTextArea.append("Resultado: Host est\u00e1 acess\u00edvel (Surface Web).\n\n");
            } else {
                this.jTextArea.append("Resultado: Host n\u00e3o respondeu ao ping.\n\n");
            }
        }
        catch (IOException e) {
            this.jTextArea.append("Erro ao pingar: " + e.getMessage() + "\n\n");
            logger.log(Level.SEVERE, "Erro ao pingar host", e);
        }
    }

    private String resolveHostAddresses(String host) {
        StringBuilder sb = new StringBuilder();
        sb.append("Endere\u00e7os IP do host:\n");
        try {
            InetAddress[] addrs = InetAddress.getAllByName(host);
            ArrayList<String> ipv4 = new ArrayList<String>();
            ArrayList<String> ipv6 = new ArrayList<String>();
            for (InetAddress addr : addrs) {
                String ip = addr.getHostAddress();
                if (addr instanceof Inet4Address) {
                    ipv4.add(ip);
                    continue;
                }
                if (!(addr instanceof Inet6Address)) continue;
                ipv6.add(ip);
            }
            if (ipv4.isEmpty()) {
                sb.append("- IPv4: nenhum endere\u00e7o encontrado\n");
            } else {
                sb.append("- IPv4: ").append(String.join((CharSequence)", ", ipv4)).append("\n");
            }
            if (ipv6.isEmpty()) {
                sb.append("- IPv6: nenhum endere\u00e7o encontrado\n");
            } else {
                sb.append("- IPv6: ").append(String.join((CharSequence)", ", ipv6)).append("\n");
            }
            sb.append("\n");
        }
        catch (IOException e) {
            sb.append("- Erro ao resolver IPs: ").append(e.getMessage()).append("\n\n");
            logger.log(Level.WARNING, "Erro ao resolver IPs", e);
        }
        return sb.toString();
    }

    private String getProxyInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("Proxy (JVM):\n");
        String httpHost = System.getProperty("http.proxyHost");
        String httpPort = System.getProperty("http.proxyPort");
        String httpsHost = System.getProperty("https.proxyHost");
        String httpsPort = System.getProperty("https.proxyPort");
        String socksHost = System.getProperty("socksProxyHost");
        String socksPort = System.getProperty("socksProxyPort");
        if (httpHost == null && httpsHost == null && socksHost == null) {
            sb.append("- Nenhum proxy configurado via propriedades da JVM\n");
        } else {
            if (httpHost != null) {
                sb.append("- HTTP: ").append(httpHost).append((String)(httpPort != null ? ":" + httpPort : "")).append("\n");
            }
            if (httpsHost != null) {
                sb.append("- HTTPS: ").append(httpsHost).append((String)(httpsPort != null ? ":" + httpsPort : "")).append("\n");
            }
            if (socksHost != null) {
                sb.append("- SOCKS: ").append(socksHost).append((String)(socksPort != null ? ":" + socksPort : "")).append("\n");
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    private String getVpnInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("VPN (heur\u00edstica por interfaces de rede):\n");
        ArrayList<String> vpnIfaces = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface ni = ifaces.nextElement();
                String name = ni.getName().toLowerCase();
                boolean candidate = name.contains("tun") || name.contains("tap") || name.contains("wg") || name.contains("ppp") || name.contains("vpn");
                if (!candidate || !ni.isUp() || ni.isLoopback()) continue;
                vpnIfaces.add(name);
            }
        }
        catch (SocketException e) {
            sb.append("- Erro ao verificar interfaces: ").append(e.getMessage()).append("\n\n");
            return sb.toString();
        }
        if (vpnIfaces.isEmpty()) {
            sb.append("- Nenhuma interface t\u00edpica de VPN detectada\n\n");
        } else {
            sb.append("- Interfaces VPN ativas: ").append(String.join((CharSequence)", ", vpnIfaces)).append("\n\n");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equalsIgnoreCase(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        SwingUtilities.invokeLater(() -> new Principal().setVisible(true));
    }
}

